﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Collections;

public class clsGPE
{
    //these constants set the command language for GPE
    //const to define the start of a sub procedure
    private const string CMD_SUB = "function";
    //const to define end script
    private const string CMD_END_SCRIPT = "end script";
    //const to define pen.off
    private const string PEN_OFF = "pen.off";
    //const to define pen.on
    private const string PEN_ON  = "pen.on";
    //const to define the call command
    private const string CMD_CALL = "call";
    //const for the north command
    private const string CMD_NORTH = "pen.north";
    //const for the south command
    private const string CMD_SOUTH = "pen.south";
    //const for the east command
    private const string CMD_EAST = "pen.east";
    //const for the west command
    private const string CMD_WEST = "pen.west";
    //const for the northwest command
    private const string CMD_NORTH_WEST = "pen.northwest";
    //const for the northeast command
    private const string CMD_NORTH_EAST = "pen.northeast";
    //const for the southwest command
    private const string CMD_SOUTH_WEST  = "pen.southwest";
    //const for the southeast command
    private const string CMD_SOUTH_EAST  = "pen.southeast";
    //const for the ink command
    private const string CMD_INK = "pen.ink";
    //const for the jumpto command
    private const string CMD_JUMP_TO = "pen.jumpto";
    //const for the clear command
    private const string CMD_CLEAR = "screen.clear";
    //const for combo to indicate no library item selected
    //const to define the prefix for grid cells
    private const string IMG_PREFIX = "imgCell";
    private const string NO_SCRIPT = "(Library)";
    private List<string> dScripts = new List<string>();
    //used to flag if code should be executed or not
    Boolean RunOK = true;

    //constant to set the size of each cell in pixels
    private const Int32 CELL_SIZE = 25;
    //constant to set the left indent of the canvas
    private const Int32 CANVAS_LEFT = 30;
    //const to set the top indent of the canvas
    private const Int32 CANVAS_TOP = 30;

    private Int32 lCanvasSize;
    private Int32 lPenPosition;
    private string lErrString;
    private List<System.Drawing.Color> lCanvas = new List<System.Drawing.Color>();
    private System.Drawing.Color lInkColour = new System.Drawing.Color();
    private string lInk;
    private Boolean lPenOn = true;


	public clsGPE(Int32 CanvasSize)
	{
        clsFileIO IO = new clsFileIO();
        string ScriptsDir = System.AppDomain.CurrentDomain.BaseDirectory + "\\scripts";
        lInkColour = System.Drawing.Color.Blue;
        lCanvasSize = CanvasSize;
        dScripts = IO.GetDirectoryContents(ScriptsDir);
        InitialiseCanvas();
	}

    public List<Byte> GetRGBList
    {
        get
        {
            Byte R, G, B;
            Int32 Count = 0;
            List<Byte> Bytes = new List<byte>();
            while (Count <= CellCount)
            {

                R = lCanvas[Count].R;
                G = lCanvas[Count].G;
                B = lCanvas[Count].B;
                Bytes.Add(R);
                Bytes.Add(G);
                Bytes.Add(B);
                Count++;
            }
            return Bytes;
        }
    }

    public Int32 CellCount
    {
        get
        {
            return (lCanvasSize * lCanvasSize) - 1;
        }
    }

    public string Ink
    {
        get
        {
            return lInk;
        }
    }

    public List<System.Drawing.Color> Canvas
    {
        get
        {
            return lCanvas;
        }
    }

    public Int32 CanvasSize
    {
        get
        {
            return lCanvasSize;
        }
    }

    public string ErrString
    {
        get
        {
            return lErrString;
        }
    }

    public Int32 X
    {
        get
        {
            //this function returns the value of the x coordinate
            return lPenPosition - ((Convert.ToInt32(lPenPosition / lCanvasSize)) * lCanvasSize);
        }
    }

    //    Public Function Y() As Integer
    public Int32 Y
    {
        get
        {
            //this function returns the value of the y coordinate
            return Convert.ToInt32(lPenPosition / lCanvasSize) + 1;
        }
    }

    public void DisplayScripts(System.Web.UI.WebControls.DropDownList DDList)
    {
        Int32 Count = 0;
        DDList.Items.Clear();
        DDList.Items.Add(NO_SCRIPT);
        DDList.Items[0].Value = "";
        while (Count < dScripts.Count)
        {
            DDList.Items.Add(dScripts[Count].ToString());
            Count++;
        }
    }



    private void PlaceLabel(System.Web.UI.Page WebPage,
                            Int32 xPosn,
                            Int32 yPosn,
                            string Label,
                            string ID)
    {
        //this sub is used to place a lable for either axis
        //it needs the following parameters
        //the x position, the y position, the text of the label and a unique id for the label
        //
        //declare a new label control
        System.Web.UI.WebControls.Label ALabel = new System.Web.UI.WebControls.Label();
        //set the ID (name)
        ALabel.ID = "lbl" + ID;
        //set the position to absolute
        ALabel.Style["Position"] = "Absolute";
        //set the top position
        ALabel.Style["Top"] = (CANVAS_TOP + 4) + (CELL_SIZE * (yPosn - 1)) + "px";
        //set the left position
        ALabel.Style["Left"] = (CANVAS_LEFT + 8) + (CELL_SIZE * (xPosn - 1)) + "px";
        //set the text of the label
        ALabel.Text = Label;
        //disable view state
        ALabel.EnableViewState = false;
        //add the control to the form
        WebPage.Controls.Add(ALabel);
    }


    private string PrepScript(string AScript)
    {
        char SomeChr;
        //convert the script to lower case
        AScript = AScript.ToLower() + Environment.NewLine;
        //add extra spaces around the assignment operator
        AScript = AScript.Replace("=", " = ");
        //add extra spaces after the jumpto command
        AScript = AScript.Replace("jumpto", "jumpto ");
        //get rid of carrage returns
        SomeChr = (char)10;
        AScript = AScript.Replace(SomeChr.ToString(), "");
        SomeChr = (char)13;
        AScript = AScript.Replace(SomeChr.ToString(), "!");
        AScript = RemoveComments(AScript);
        return AScript;
    }

    private string RemoveComments(string ASCript)
    {
        Int32 Count = 0;
        string NewScript = "";
        string[] Commands = ASCript.Split('!');
        string Command;
        //Int32 ArSize = Commands.GetUpperBound(0);
        //        For Counter = 0 To Commands.GetUpperBound(0)
        while (Count < Commands.GetUpperBound(0))
        {
            Command = Commands[Count];
            if (Command.Length >= 2)
            {
                if (Command.Substring(0, 2) != "//")
                {
                    NewScript = NewScript + Command;
                }
            }
            else
            {
                NewScript = NewScript + Command;
            }
            Count++;
        }
        return NewScript;
    }

    private string ExtractFunction(string SubName,
                                   string AScript,
                                   ref Boolean Abort)
    {
        //this function extracts the code for a sub procedure
        //it accepts three parameters
        //the name of the script to extract
        //the script containing the sub
        //abort is passed by ref in case anything goes wrong
        //
        //var to point to the start of the script
        Int32 ScriptStart;
        //var to point to the end of the script
        Int32 ScriptEnd;
        //assume all is well
        Abort = false;
        //find the start of the script
        ScriptStart = AScript.IndexOf(CMD_SUB + " " + SubName + "{");
        //if start found
        if (ScriptStart != 0)
        {
            //set the pointer to the start
            ScriptStart = ScriptStart + CMD_SUB.Length + 2 + SubName.Length;
        }
        else
        {
            //otherwise display an error message
            lErrString = lErrString + "cannot find " + SubName + Environment.NewLine;
            //abort everything
            Abort = true;
        }
        //find the end of the script
        ScriptEnd = AScript.IndexOf("}", ScriptStart);
        //if the end of the script not found
        if (ScriptEnd == 0)
        {
            //display an error
            lErrString = lErrString + "cannot find end function for " + SubName + Environment.NewLine;
            //abort the operation
            Abort = true;
        }
        //if no abort
        if (Abort == false)
        {
            //extract the script
            return AScript.Substring(ScriptStart, ScriptEnd - ScriptStart);
        }
        else
        {
            //return a blank string
            return "";
        }
    }

    private Int32 GetRepeats(string ACommand)
    {
        //this function extracts the number of repeats
        //on a direction command eg north 6
        //it requires one parameter which is the full command
        //
        //var to store the number of repeats
        string Repeats;
        //var to store the position of the space
        Int32 SpacePosn;
        //strip out the brackets
        ACommand = ACommand.Replace("(", " ");
        ACommand = ACommand.Replace(")", "");
        //get the position of the space
        SpacePosn = ACommand.IndexOf(" ");
        if (SpacePosn != -1)
        {
            //get the number of repeats
            Repeats = ACommand.Substring(SpacePosn);
            //if it is numeric then 
            try
            {
                //return the value
                return Convert.ToInt32(Repeats);
            }
            catch
            {
                //otherwise return 1
                return 1;
            }
        }
        else
        {
            return 1;
        }
    }

    private string GetCommand(string ACommand)
    {
        //this function extracts the command from a single line
        //it requires one parameter which is the full command
        //
        //trim the string
        ACommand = ACommand.Trim();
        //var to stor the space position
        Int32 SpacePosn;
        //get the space position
        SpacePosn = ACommand.IndexOf(" ");
        if (SpacePosn == -1)
        {
            SpacePosn = ACommand.IndexOf("(");
        }
        //if a space is found
        if (SpacePosn > 0)
        {
            //get everything to the left of the command
            return ACommand.Substring(0,SpacePosn);
        }
        else
        {
            //otherwise return a blank string
            return ACommand;
        }
    }

    private string GetValue(string ACommand)
    {
        //this sub gets the value of an assignment operation
        //it accepts one parameter wich is the full command to be executed
        //
        //var to store the position of the = sign
        Int32 AssignmentPosn;
        //get the position
        AssignmentPosn = ACommand.IndexOf("=");
        //if a = is present
        if (AssignmentPosn > 0)
        {
            //return the trimmed text to the right of it
            string temp;
            temp = ACommand.Substring(AssignmentPosn + 1);
            temp = temp.Trim();
            return temp;
        }
        else
        {
            //otherwise return a blank string
            return "";
        }
    }

    private string GetFunctionName(string ACommand)
    {
        //this function extracts the name of a sub from a call command
        //it accepts one parameter which is the full call command to be run
        //
        //var to store the space position
        Int32 SpacePosn;
        //get the space position
        SpacePosn = ACommand.IndexOf(" ");
        //return everything right of the space
        string temp = ACommand.Substring(SpacePosn + 1);
        return temp;
    }

    private Boolean GetNewXY(string ScriptName,
                             string ACommand,
                             Int32 LineNo,
                             ref Int32 NewX,
                             ref Int32 NewY)
    {
        //this sub extracts the parameters from the jump to commmand
        //it retunrs true or false depending on if this works or not
        //it requires three parameters
        //the name of the current script / sub script
        //the command to be executed including parameters
        //the line number
        //the parameters new x and new y are set by the sub
        //
        //used to point to the open bracket in the string
        Int32 OpenBracketPosn;
        //used to point to the close bracket in the string
        Int32 CloseBracketPosn;
        //used to store the parameters with the comma
        string Parameters;
        //used to store the position of the comma
        Int32 CommaPosn;
        //used to store the new x position
        Int32 stNewx=0;
        //used to store the new y position
        Int32 stNewy=0;
        //flags if all is ok
        Boolean OK = false;
        Boolean ParamOK = true;
        //get the position of the open bracket
        OpenBracketPosn = ACommand.IndexOf("(") + 1;
        //get the position of the close bracket
        CloseBracketPosn = ACommand.IndexOf(")") + 1;
        //if both brackets are found and the open is before the close
        if (OpenBracketPosn != 0 & CloseBracketPosn != 0 & OpenBracketPosn < CloseBracketPosn)
        {
            //get the parameters between the brackets
            Parameters = ACommand.Substring(OpenBracketPosn, CloseBracketPosn - (OpenBracketPosn + 1));
            //find the position of the comma
            CommaPosn = Parameters.IndexOf(",")+1;
            //if there is a comma
            if (CommaPosn > 0)
            {
                //if the first parameter is numeric
                try
                {
                    //extract it
                    string temp = Parameters.Substring(0, CommaPosn - 1);
                    stNewx = Convert.ToInt32(temp);
                }
                catch
                {
                    //display an error
                    lErrString = lErrString + " Not a valid value for an x coordinate, line " + LineNo + " " + ScriptName + Environment.NewLine;
                    ParamOK = false;
                }
                //if the second parameter is numeric
                try
                {
                    //extract it
                    string temp = Parameters.Substring(CommaPosn);
                    stNewy = Convert.ToInt32(temp);
                }
                catch
                {
                    //display an error
                    lErrString = lErrString + " Not a valid value for a y coordinate, line " + LineNo + " " + ScriptName + Environment.NewLine;
                    ParamOK = false;
                }
                //if both extracted parameters are numeric
                if (ParamOK == true)
                {
                    //set the value of new x
                    NewX = stNewx;
                    //set the value of new y
                    NewY = stNewy;
                    //flag ok as true
                    OK = true;
                }
            }
            else
            {
                //show there is an error due to missing comma
                lErrString = lErrString + "Comma missing in " + CMD_JUMP_TO + " command, line " + LineNo + " " + ScriptName + Environment.NewLine;
            }
                //        Else
        }
        else
        {
        //            'show there is a problem with the brackets
            lErrString = lErrString + "Bracket error in " + CMD_JUMP_TO + " command, line " + LineNo + " " + ScriptName + Environment.NewLine;
        //        End If
        }
        return OK;
        //    End Function
    }

    private void MovePen(string Direction, Int32 Repeats)
    {
        //this sub calls the appropriate sub based on the direction command
        //passed as a parameter
        Int32 Counter = 0;
        //
        //loop for the number of times to repeat
        while (Counter < Repeats)
        {
            //set the last position of the pen to the current ink colour
            lCanvas[lPenPosition - 1] = lInkColour;
            //if command is north
            if (Direction == CMD_NORTH)
            {
                //move north
                MoveNorth();
            }
            //if command is south
            else if (Direction == CMD_SOUTH)
            {
                //move south
                MoveSouth();
            }
            //if command is east
            else if (Direction == CMD_EAST)
            {
                //move east
                MoveEast();
            }
            //if command is west
            else if (Direction == CMD_WEST)
            {
                //move west
                MoveWest();
            }
            //if command is north east
            else if (Direction == CMD_NORTH_EAST)
            {
                //move north east
                MoveNorthEast();
            }
            //if command is north west
            else if (Direction == CMD_NORTH_WEST)
            {
                //move north west
                MoveNorthWest();
            }
            //if command is south east
            else if (Direction == CMD_SOUTH_EAST)
            {
                //move south east
                MoveSouthEast();
            }
            //if command is south west
            else if (Direction == CMD_SOUTH_WEST)
            {
                //move south west
                MoveSouthWest();
            }
            //mark the pen on the canvas
            DrawPen();
            Counter++;
        }
    }

    private void MoveEast()
    {
        //this sub moves the pointer east
        //
        //if the new pen position is still within the canvas
        if (lPenPosition < (lCanvasSize * lCanvasSize))
        {
            //move the pen
            lPenPosition += 1;
        }
    }

    private void MoveWest()
    {
        //this sub moves the pointer west
        //
        //if the new pen position is still within the canvas
        if (lPenPosition > 1)
        {
            //move the pen
            lPenPosition -= 1;
        }
    }

    private void MoveNorth()
    {
        //this sub moves the pointer north
        //
        //if the new pen position is still within the Canvas
        if ((lPenPosition - lCanvasSize) >= 1)
        {
            //move the pen
            lPenPosition -= lCanvasSize;
        }
    }

    private void MoveSouth()
    {
        //this sub moves the pointer south
        //
        //if the new pen position is still within the canvas
        if ((lPenPosition + lCanvasSize) <= (lCanvasSize * lCanvasSize))
        {
            //move the pen
            lPenPosition += lCanvasSize;
        }
    }

    private void MoveNorthEast()
    {
        //this sub moves the pointer north east
        //
        //if the new pen position is still within the canvas
        if (((lPenPosition - lCanvasSize) > 1) & (lPenPosition < (lCanvasSize * lCanvasSize)))
        {
            //move the pen
            lPenPosition -= (lCanvasSize - 1);
        }
    }

    private void MoveNorthWest()
    {
        //this sub moves the pointer north west
        //
        //if the new pen position is still within the canvas
        if (((lPenPosition - lCanvasSize) > 1) & (lPenPosition > 1))
        {
            //move the pen
            lPenPosition -= (lCanvasSize + 1);
        }
    }

    private void MoveSouthEast()
    {
        //this sub moves the pointer south east
        //
        //if the new pen position is still within the canvas
        if (((lPenPosition + lCanvasSize) < (lCanvasSize * lCanvasSize)) & (lPenPosition < (lCanvasSize * lCanvasSize)))
        {
            //move the pen
            lPenPosition += (lCanvasSize + 1);
        }
    }

    private void MoveSouthWest()
    {
        //this sub moves the pointer south west
        //
        //if the new pen position is still within the canvas
        if (((lPenPosition + lCanvasSize) <= (lCanvasSize * lCanvasSize)) & (lPenPosition > 1))
        {
            //move the pen
            lPenPosition += (lCanvasSize - 1);
        }
    }

    private void DrawPen()
    {
        if (lPenOn)
        {
            lCanvas[lPenPosition - 1] = System.Drawing.Color.Black;
        }
        else
        {
            lCanvas[lPenPosition - 1] = lInkColour;
        }
    }

    private void JumpTo(Int32 X, Int32 Y)
    {
        //set the old pen position to the current ink colour
        lCanvas[lPenPosition - 1] = lInkColour;
        //if the new pen position is still within the canvas
        if (((((Y - 1) * lCanvasSize) + X) >= 1) & ((((Y - 1) * lCanvasSize) + X) <= (lCanvasSize * lCanvasSize)))
        {
            //move the pen position
            lPenPosition = ((Y - 1) * lCanvasSize) + X;
        }
        else
        {
            //display an error message
            lErrString = lErrString + CMD_JUMP_TO + " " + X + "," + Y + " takes pointer put of the grid" + Environment.NewLine;
        }
        //set the new position of the pen to the pen colour
        DrawPen();
    }

    private void SetInk(string SelectedInk)
    {
        //this sub sets the ink colour of the pen
        //it accepts on parameter stating the ink colour as a string
        //
        //display the new ink colour on th epage
        lInk = "Ink=" + SelectedInk;
        //set the pen colour
        lInkColour = GetInk(SelectedInk);
    }

    private System.Drawing.Color GetInk(string Colour)
    {
        System.Drawing.Color Ink = System.Drawing.Color.Black;
        //if the ink is black
        if (Colour == "black")
        {
            //set the pen colour to black
            Ink = System.Drawing.Color.Black;
        }
        //if the ink is red
        else if (Colour == "red")
        {
            //set the pen colour to red
            Ink = System.Drawing.Color.Red;
        }
        //if the ink is blue
        else if (Colour == "blue")
        {
            //set the pen colour to blue
            Ink = System.Drawing.Color.Blue;
        }
        //if the ink is green
        else if (Colour == "green")
        {
            //set the pen colour to green
            Ink = System.Drawing.Color.Green;
            
        }
        //if the ink is white
        else if (Colour == "white")
        {
            //set the pen colour to white
            Ink = System.Drawing.Color.White;
        }
        else
        {
            //display an error
            lInk = "";
        }
        return Ink;
    }

    private void ClearAll()
    {
        //this sub clears the canvas
        Int32 Count = 0;
        //loop through each element in the canvas
        while (Count < lCanvas.Count)
        {
            //set the cell to white
            lCanvas[Count] = System.Drawing.Color.White;
            Count++;
        }
        //draw the pen
        DrawPen();
    }

    private Boolean IsDirection(string CommandToRun)
    {
        //    Public Function IsDirection(ByVal CommandToRun As String) As Boolean
        //        'this function checks to see if a command is a direction commend eg N S E W
        //        'it accepts one parameter - the command to run
        //        '
        //        'var to store ok - assume it is not ok
        Boolean OK = false;
        //if the command is north
        if (CommandToRun == CMD_NORTH)
        {
            //set ok to true
            OK = true;
        }
        //if the command is south
        else if (CommandToRun == CMD_SOUTH )
        {
            //set ok to true
            OK = true;
        }
        //if the command is east
        else if (CommandToRun == CMD_EAST )
        {
            //set ok to true
            OK = true;
        }
        //            'if the command is west
        else if (CommandToRun == CMD_WEST )
        {
            //set ok to true
            OK = true;
        }
        //if the command is north east
        else if (CommandToRun == CMD_NORTH_EAST )
        {
            //set ok to true
            OK = true;
        }
        //            'if the command is north east
        else if (CommandToRun == CMD_NORTH_WEST )
        {
            //set ok to true
            OK = true;
        }
        //if the command is south east
        else if (CommandToRun == CMD_SOUTH_EAST)
        {
            //set ok to true
            OK = true;
        }
        //if the command is south west
        else if (CommandToRun == CMD_SOUTH_WEST)
        {
            //set ok to true
            OK = true;
        }
        //return the state of ok
        return OK;
    }

    private void InitialiseCanvas()
    {
        //this sub initialises the array containing the canvas
        //
        //var to store the number of the current element
        Int32 Element=0;
        //loop through each element in the array
        while (Element <= CellCount)
        {
            //create a new canvas element
            System.Drawing.Color ACell = new System.Drawing.Color();
            //set the cell colour to white
            ACell = System.Drawing.Color.White;
            //add the cell to the baord
            lCanvas.Add(ACell);
            Element++;
        }
        //set the pen to the top left hand corner
        lPenPosition = 1;
        //jump to top left hand corner
        JumpTo(1, 1);
    }

    private void RunCommand(string ACommand,
                            string AScript,
                            Int32 LineNo,
                            string SubName)
    {
        //this sub processes individual commands
        //it accepts three parameters
        //the command to be run
        //the script
        //the current line number
        //the name of the current sub procedure if appropriate
        //
        //var to contain the actual command to be run (without parameters etc)
        string CommandToRun;
        //name of the new ink colour
        string NewInk;
        //used in the jump to command
        Int32 NewxPosn = 0;
        //used in the jump to command
        Int32 NewyPosn = 0;
        //used to store the code for a sub script
        string SubScriptCode;
        //used to abort processing if there is a problem
        Boolean Abort = false;
        //var to store the number of times a command should repeat
        Int32 Repeats;
        //get the actual command to run
        CommandToRun = GetCommand(ACommand);
        //if we are still running commands
        if (RunOK == true)
        {
            //if the command is a direction comand eg n s e w
            if (IsDirection(CommandToRun) == true)
            {
                //get the number of repeats on the direction
                Repeats = GetRepeats(ACommand);
                //move the pen
                MovePen(CommandToRun, Repeats);
            }
            //if the command is an ink command
            else if (CommandToRun == CMD_INK)
            {
                //get the new ink colour
                NewInk = GetValue(ACommand);
                //if an ink has been specified 
                if (NewInk != "")
                {
                    //set the ink
                    SetInk(NewInk);
                }
                else
                {
                    //otherwise show an error
                    lErrString = lErrString + "missing assignment operator in line " + LineNo + " " + SubName + Environment.NewLine;
                }
            }
            //if the command is a jumpto command
            else if (CommandToRun == CMD_JUMP_TO)
            {
                //get the new x and y assuming all is well
                if (GetNewXY(SubName, ACommand, LineNo, ref NewxPosn, ref NewyPosn) == true)
                {
                    //if all is well then jump to that position
                    JumpTo(Convert.ToInt32(NewxPosn), Convert.ToInt32(NewyPosn));
                }
            }
            //if the command is clear 
            else if (CommandToRun == CMD_CLEAR)
            {
                //call the clear sub
                ClearAll();
            }
            //                'if the command is the name of a sub then stop processing
            else if (CommandToRun == CMD_SUB)
            {
                //turn off command processing
                RunOK = false;
            }
            //if the command is a call
            else if (CommandToRun == CMD_CALL)
            {
                //get the name of the sub to run
                SubName = GetFunctionName(ACommand);
                //extract the code for that sub
                SubScriptCode = ExtractFunction(SubName, AScript, ref Abort);
                //if no problems
                if (Abort == false)
                {
                    //run the sub script
                    RunScript(SubScriptCode, CMD_SUB + " " + SubName);
                }
            }
            else if (CommandToRun == PEN_OFF)
            {
                lPenOn = false;
            }
            else if (CommandToRun == PEN_ON)
            {
                lPenOn = true;
            }
            else
            {
                //if the command is not a blank line or a comment
                if ((CommandToRun != "") & (CommandToRun.Substring(2) != "\\"))
                {
                    //display an error message stating command not known
                    lErrString = lErrString + CommandToRun + " not a known command, line " + LineNo + " " + SubName + Environment.NewLine;
                }
            }
            //if the current line is an end (end sub or end script)
            if (ACommand.Substring(3) == "end")
            {
                //            'turn on processing
                RunOK = false;
            }
        }
    }

    public void RunScript(string FullScript, string SubScriptName)
    {
        //this sub is used to process a script / subscript
        //it accepts three parameters 
        //a boolean flag to indicate that this is the start of a script and not a sub script
        //the script itself
        //the name of any sub script to be run
        //
        //clear any previous errors messages
        lErrString = "";
        //static variable to store the new position pointer in the string 
        Int32 NewPosn = 0;
        //static variable to store the old psotion pointer in the string
        Int32 OldPosn = 0;
        //static var to store the line number being processed
        Int32 LineNo = 0;
        //var to store the text of the current command
        string CommandText;
        string ThisChar="";
        FullScript = PrepScript(FullScript);
        //loop while the script is not done
        while (NewPosn < FullScript.Length)
        {
            //the character at new position is a line feed character
            ThisChar = FullScript.Substring(NewPosn, 1);
            if (ThisChar == ";" & RunOK == true)
            {
                //get the text between old position and new position
                CommandText = FullScript.Substring(OldPosn, (NewPosn - OldPosn));                
                //move old position 1 char beyond new position
                OldPosn = NewPosn +1;
                //increase the line number
                LineNo += 1;
                //if the command is not marking the end of the script
                if (CommandText != CMD_END_SCRIPT)
                {
                    //run the command
                    RunCommand(CommandText, FullScript, LineNo, SubScriptName);
                }
                else
                {
                    //send new position to the end of the script
                    NewPosn = FullScript.Length;
                }
            }
            if (ThisChar == "}" & RunOK == false)
            {
                RunOK = true;
                OldPosn++;
            }
            //increase the new position pointer
            NewPosn += 1;
        }
    }

    public string LoadScript(string ScriptName)
    {
        //this sub loads the script from the scripts library (look in the scripts folder)
        //it accepts one parameter which is the file name of the script to load
        //if the script is not found it will crash
        //
        string Script = "";
        //if a script has been selected
        if (ScriptName != "")
        {
            //get the local path of the current web site
            string FileName = System.AppDomain.CurrentDomain.BaseDirectory + "scripts\\"  + ScriptName;
            clsFileIO IO = new clsFileIO();
            Script = IO.ReadTextFile(FileName);
        }
        //return the script
        return Script;
    }

    public void RefreshWebGrid(System.Web.UI.Page WebPage)
    {
        //this sub displays the contents of the array on the screen
        //
        //var for loop
        Int32 Count = 0;
        //loop through each element of the array
        while (Count <= CellCount)
        {
            //create a new image control
            System.Web.UI.WebControls.Image ImgCell = new System.Web.UI.WebControls.Image();
            //find the image control on the screen for this array element and make a copy of it
            ImgCell = (System.Web.UI.WebControls.Image)WebPage.FindControl(IMG_PREFIX + Count);
            //set the back ground colour to the colour of this array element
            ImgCell.BackColor = lCanvas[Count];
            //remove the old image control from the screen
            WebPage.Controls.Remove(ImgCell);
            //add the new image control
            WebPage.Controls.Add(ImgCell);
            Count++;
        }
    }

    public void BuildWebGrid(System.Web.UI.Page WebPage)
    {
        //this sub creates the display area on the page
        //
        //var to store the x position of each cell
        Int32 xPosn;
        //var to store the y position of each cell
        Int32 yPosn = 0;
        //var to store the id of each control
        Int32 Count;
        //start at 0 for control id
        Count = 0;
        //loop through y axis
        //        For yPosn = 0 To lCanvasSize - 1
        while (yPosn < lCanvasSize)
        {
            xPosn = 0;
            //draw the labels for the y axis
            PlaceLabel(WebPage,
                        0,
                        yPosn + 1,
                        Convert.ToString(yPosn + 1),
                        "y" + Count.ToString());
            //loop through x axis
            //            For xPosn = 0 To lCanvasSize - 1
            while (xPosn < lCanvasSize)
            {
                //if this is the first column
                if (yPosn == 0)
                {
                    //draw the x axis labels as well
                    PlaceLabel(WebPage, xPosn + 1, 0, Convert.ToString(xPosn + 1), "x" + Count.ToString());
                }
                //declare an image control
                System.Web.UI.WebControls.Image ImgCell = new System.Web.UI.WebControls.Image();
                //set the ID (name) of the control
                ImgCell.ID = IMG_PREFIX + Count;
                //set the positioning of the control to absolute
                ImgCell.Style["Position"] = "Absolute";
                //set the top position of the control
                ImgCell.Style["Top"] = CANVAS_TOP + (CELL_SIZE * yPosn) + "px";
                //set the left position of the control
                ImgCell.Style["Left"] = CANVAS_LEFT + (CELL_SIZE * xPosn) + "px";
                //set the image for the cell to blank
                ImgCell.ImageUrl = "blank.gif";
                //add the image control to the page
                WebPage.Controls.Add(ImgCell);
                //increase the image counter
                Count++;
                xPosn++;
            }
            yPosn++;
        }
    }

}